
import React from 'react';

interface SquareProps {
  value: 'X' | 'O' | null;
  onClick: () => void;
  isWinnerSquare: boolean;
}

const Square: React.FC<SquareProps> = ({ value, onClick, isWinnerSquare }) => {
  const textClass = value === 'X' ? 'text-sky-400' : 'text-amber-400';
  const winnerClass = isWinnerSquare ? 'bg-green-700' : 'bg-gray-800 hover:bg-gray-700';

  return (
    <button
      className={`w-24 h-24 md:w-32 md:h-32 m-1 rounded-lg flex items-center justify-center
      text-6xl font-bold transition-colors duration-200 ease-in-out ${winnerClass} ${textClass}`}
      onClick={onClick}
    >
      {value}
    </button>
  );
};

export default Square;
