import React from 'react';
import { Link } from 'react-router-dom';

interface Game {
    id: string;
    name: string;
    description: string;
    icon: string;
    path: string;
    available: boolean;
}

const games: Game[] = [
    { id: 'tictactoe', name: 'دوز', description: 'یک بازی کلاسیک و سریع برای دو نفر.', icon: '🎲', path: '/lobby/tictactoe', available: true },
    { id: 'ludo', name: 'منچ', description: 'شانس و استراتژی خود را در این بازی محبوب محک بزنید.', icon: '🎯', path: '/lobby/ludo', available: true },
    { id: 'chess', name: 'شطرنج', description: 'مهارت‌های استراتژیک خود را در بازی شاهان به چالش بکشید.', icon: '♟️', path: '/lobby/chess', available: true },
    { id: 'backgammon', name: 'تخته نرد', description: 'ترکیبی از شانس و مهارت در یکی از قدیمی‌ترین بازی‌های جهان.', icon: '🎲', path: '/lobby/backgammon', available: true },
];

const GameCard: React.FC<{ game: Game }> = ({ game }) => {
    const content = (
         <div className={`bg-gray-800 border border-gray-700 rounded-lg p-6 flex flex-col items-center text-center transition-all duration-300 ${game.available ? 'hover:border-indigo-500 hover:shadow-indigo-500/20 hover:-translate-y-1' : 'opacity-50 cursor-not-allowed'}`}>
            <div className="text-6xl mb-4">{game.icon}</div>
            <h3 className="text-2xl font-bold text-white mb-2">{game.name}</h3>
            <p className="text-gray-400 mb-4 flex-grow">{game.description}</p>
            {game.available ? (
                <span className="w-full mt-auto bg-indigo-600 text-white font-bold py-2 px-6 rounded-lg transition-colors hover:bg-indigo-700">
                    بازی کن
                </span>
            ) : (
                <span className="w-full mt-auto bg-gray-600 text-gray-300 font-bold py-2 px-6 rounded-lg">
                    به زودی...
                </span>
            )}
        </div>
    );
    
    return game.available ? <Link to={game.path} className="block">{content}</Link> : <div className="block">{content}</div>;
};

const GameSelection: React.FC = () => {
    return (
        <div className="flex-grow container mx-auto p-4 md:p-8">
            <div className="text-center mb-12">
                <h1 className="text-4xl md:text-5xl font-bold mb-4 text-white">لیست بازی‌ها</h1>
                <p className="text-lg text-gray-400">بازی مورد علاقه خود را انتخاب کنید و دوستانتان را به چالش بکشید!</p>
            </div>
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                {games.map(game => (
                    <GameCard key={game.id} game={game} />
                ))}
            </div>
        </div>
    );
};

export default GameSelection;
