import React from 'react';
import { Link } from 'react-router-dom';

const Home: React.FC = () => {
  return (
    <div className="flex-grow flex items-center justify-center bg-gray-900 text-white">
      <div className="text-center p-8">
        <div className="relative inline-block mb-8">
            <h1 className="text-5xl md:text-7xl font-extrabold tracking-tight">
                <span className="bg-clip-text text-transparent bg-gradient-to-r from-purple-400 to-indigo-600">
                    Game Zone
                </span>
            </h1>
            <span className="absolute -top-2 -right-4 text-4xl animate-pulse">🎮</span>
        </div>
        <p className="text-xl md:text-2xl text-gray-300 max-w-2xl mx-auto mb-10">
          به بهترین پلتفرم برای بازی‌های چندنفره آنلاین خوش آمدید. دوستان خود را به چالش بکشید، امتیاز کسب کنید و به صدر جدول برسید!
        </p>
        <div className="flex flex-col sm:flex-row items-center justify-center gap-4">
          <Link
            to="/games"
            className="w-full sm:w-auto bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-full text-lg transition-transform transform hover:scale-105 shadow-lg"
          >
            همین حالا بازی کن!
          </Link>
          <Link
            to="/leaderboard"
            className="w-full sm:w-auto bg-gray-700 hover:bg-gray-600 text-white font-bold py-3 px-8 rounded-full text-lg transition-transform transform hover:scale-105 shadow-lg"
          >
            مشاهده جدول امتیازات
          </Link>
        </div>
      </div>
    </div>
  );
};

export default Home;