
import React from 'react';

const Rules: React.FC = () => {
  return (
    <div className="flex-grow container mx-auto p-8 text-gray-200">
      <div className="bg-gray-800 p-8 rounded-lg shadow-xl border border-gray-700">
        <h1 className="text-4xl font-bold mb-6 text-center text-white">قوانین و مقررات Game Zone</h1>
        
        <div className="space-y-6 text-lg leading-relaxed">
          <section>
            <h2 className="text-2xl font-semibold mb-3 text-indigo-400">۱. حساب کاربری</h2>
            <ul className="list-disc list-inside space-y-2 pr-4">
              <li>هر کاربر مسئول حفظ امنیت حساب کاربری و رمز عبور خود می‌باشد.</li>
              <li>ایجاد چندین حساب کاربری توسط یک شخص ممنوع است.</li>
              <li>استفاده از نام‌های کاربری توهین‌آمیز یا نامناسب مجاز نیست.</li>
            </ul>
          </section>

          <section>
            <h2 className="text-2xl font-semibold mb-3 text-indigo-400">۲. رفتار در بازی</h2>
            <ul className="list-disc list-inside space-y-2 pr-4">
              <li>احترام به سایر بازیکنان الزامی است. هرگونه توهین، تهدید یا آزار و اذیت منجر به مسدود شدن حساب کاربری خواهد شد.</li>
              <li>هرگونه تقلب، استفاده از باگ‌ها یا نرم‌افزارهای جانبی برای کسب برتری ناعادلانه اکیداً ممنوع است.</li>
              <li>خروج عمدی از بازی در حین مسابقه (Rage Quit) ممکن است منجر به کسر امتیاز شود.</li>
            </ul>
          </section>

          <section>
            <h2 className="text-2xl font-semibold mb-3 text-indigo-400">۳. سیستم امتیازدهی</h2>
            <ul className="list-disc list-inside space-y-2 pr-4">
              <li>امتیازات بر اساس برد، باخت و تساوی محاسبه می‌شوند.</li>
              <li>برد: ۳ امتیاز</li>
              <li>مساوی: ۱ امتیاز</li>
              <li>باخت: ۰ امتیاز</li>
              <li>مدیریت سایت این حق را برای خود محفوظ می‌دارد که در صورت مشاهده فعالیت‌های مشکوک، امتیازات را تغییر دهد.</li>
            </ul>
          </section>

          <p className="pt-4 text-center text-gray-400">
            با ثبت نام و استفاده از این پلتفرم، شما موافقت خود را با تمامی این قوانین اعلام می‌کنید. این قوانین ممکن است در آینده تغییر کنند.
          </p>
        </div>
      </div>
    </div>
  );
};

export default Rules;
