
import type { User, Score } from '../types';

const USERS_KEY = 'gamezone_users';
const SCORES_KEY = 'gamezone_scores';

const getInitialScores = (): Score[] => {
  const initialUsers: User[] = [
    { id: 'user-1', username: 'آرش' },
    { id: 'user-2', username: 'سارا' },
    { id: 'user-3', username: 'مریم' },
  ];

  return [
    { userId: 'user-1', username: 'آرش', wins: 15, losses: 5, draws: 2, points: 47 },
    { userId: 'user-2', username: 'سارا', wins: 12, losses: 8, draws: 3, points: 39 },
    { userId: 'user-3', username: 'مریم', wins: 10, losses: 10, draws: 1, points: 31 },
  ];
};


// User Management
export const getUsers = (): User[] => {
  try {
    const users = localStorage.getItem(USERS_KEY);
    return users ? JSON.parse(users) : [];
  } catch (error) {
    console.error("Error fetching users from localStorage", error);
    return [];
  }
};

export const saveUsers = (users: User[]): void => {
  try {
    localStorage.setItem(USERS_KEY, JSON.stringify(users));
  } catch (error) {
    console.error("Error saving users to localStorage", error);
  }
};

// Score Management
export const getScores = (): Score[] => {
  try {
    const scores = localStorage.getItem(SCORES_KEY);
    if (scores) {
      return JSON.parse(scores);
    } else {
      const initialScores = getInitialScores();
      saveScores(initialScores);
      return initialScores;
    }
  } catch (error) {
    console.error("Error fetching scores from localStorage", error);
    return getInitialScores();
  }
};

export const saveScores = (scores: Score[]): void => {
  try {
    localStorage.setItem(SCORES_KEY, JSON.stringify(scores));
  } catch (error) {
    console.error("Error saving scores to localStorage", error);
  }
};
